function writeOC(basename,oc)
%writeOC(fname,oc) --- write output control file
% TO 070630 081226


% Copyright 2009 Theo Olsthoorn, TU-Delft and Waternet, without any warranty
% under free software foundation GNU license version 3 or later

fid=fopen([basename, '.',oc.ext],'wt');

%0
fprintf(fid,'# MATLAB writeOC %s\n',datestr(now));
fprintf(    '# MATLAB writeOC %s\n',datestr(now));

%1 IHEDFM IDDNFM IHEDUN IDDNUN (For each simulation)
fprintf(fid,'%10d%10d%10d%10d     IHEDFM IDDNFM IHEDUN IDDNUN \n',...
    oc.IHEDFM,oc.IDDNFM,oc.IHEDUN,oc.IDDNUN);
    %  IHEDFM head     print format code 0..12
    %  IDDNFM drawdown print format code 0..12
    %  ISURFM interphase print format code 0..12
    %  IHEDUN unit number of file to save heads
    %  IDDNUN unit number of flle to save drawdowns
    %  ISURUN unit number of flle to save drawdowns

if oc.INCODE(1)<0, oc.INCODE(1)=0; end  % the first one must >=0,
                % so that one following record is read to specify what to print

%2
for iP=1:oc.NPER  % for each stress period

    k=0; % time step coutner reset at beginning of each stress period
    
    for iS=1:oc.NSTP(iP)  % for all time steps within this stress period

        k=k+1; % counting of total number of time steps
        
        %2 INCODE IHDDFL IBUDSV ICBCFL

        % printing desired only if ihddfl>0
        % we use ihdffl>0 as a print-frequency counter (within stress
        % period. We'll always save at the end of each stress period
        % ihhdfl is either k or zero
        %                   (last tstp in stress per || multiple of print interval reached)
        ihddfl = k * (oc.IHDDFL(iP)~=0 && (k==oc.NSTP(iP) || rem(k,oc.IHDDFL(iP))==0));
        ibudfl = k * (oc.IBUDFL(iP)~=0 && (k==oc.NSTP(iP) || rem(k,oc.IBUDFL(iP))==0));
        icbcfl = k * (oc.ICBCFL(iP)~=0 && (k==oc.NSTP(iP) || rem(k,oc.ICBCFL(iP))==0));
            
        fprintf(fid,'%10d%10d%10d%10d     INCODE(%d) IHDDFL(%d) IBUDFL(%d) ICBCFL(%d)\n',...
            min(oc.INCODE(iP),0),ihddfl,ibudfl,icbcfl,k,k,k,k);
        % INCODE note
        %   <0 use codes from last stress period are used
        %   0= all layers same, read only one record of item 3
        %   >0 read output codes for each layer --- not implemented
        %   mflab always treats all layers the same to prevent confusion
        %   of which layers have been saved and very long OC input files
        % IHHDFL
        %   0= don't print heads or drawdown whatever item 3 says
        %   <>0 use item 3 codes to decide on printing
        %   and use abs(IHHDFL) as print frequency
        % IBUDFL
        %   0= don't print overall volumetric budget
        %   <>0 print overall volumetric budget at given frequency
        % ICBCFL
        %   0= don't write cell to cell flows to any file
        %  <>0 save cell to cell flows at given frequency to budget file depending
        %  on flag in the other package parameters I....CB

        if min(0,oc.INCODE(iP))==0  % Prevent>0 to treat all layers equally
            %3 Hdpr Ddpr Hdsv Ddsv    This is in fact layer specific
            fprintf(fid,'%10d%10d%10d%10d     Hdpr(%d) Ddpr(%d) Hdsv(%d) Ddsv(%d)\n',...
                oc.Hdpr(iP),oc.Ddpr(iP),oc.Hdsv(iP),oc.Ddsv(iP),k,k,k,k);
            %  Hdpr  <>0 prints head otherwise no printing
            %  Ddpr  <>0 prints ddn  otherwise no printing
            %  Hdsv  <>0 saves  head otherwise no saving
            %  Ddsv  <>0 saves  ddn  otherwise no saving
        else   % i.e oc.INCODE(iP)<0 so no printing is desired in this stress period
            % item % 3 is not read
        end
    end
end

fclose(fid);
